/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class BitterFeudEntersBattlefieldEffect
extends OneShotEffect {
    BitterFeudEntersBattlefieldEffect() {
        super(Outcome.Damage);
        this.staticText = "choose two players";
    }

    private BitterFeudEntersBattlefieldEffect(BitterFeudEntersBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        TargetPlayer target = new TargetPlayer(2, 2, true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        Player player1 = game.getPlayer(target.getFirstTarget());
        if (player1 == null) {
            return false;
        }
        if (target.getTargets().size() <= 1) {
            return false;
        }
        Player player2 = game.getPlayer((UUID)target.getTargets().get(1));
        if (player2 == null) {
            return false;
        }
        game.getState().setValue(source.getSourceId() + "_player1", (Object)player1);
        game.getState().setValue(source.getSourceId() + "_player2", (Object)player2);
        game.informPlayers(permanent.getLogName() + ": " + controller.getLogName() + " has chosen " + player1.getLogName() + " and " + player2.getLogName());
        permanent.addInfo("chosen players", "<font color = 'blue'>Chosen players: " + player1.getName() + ", " + player2.getName() + "</font>", game);
        return true;
    }

    public BitterFeudEntersBattlefieldEffect copy() {
        return new BitterFeudEntersBattlefieldEffect(this);
    }
}

