/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class BlackCatCunningThiefEffect
extends OneShotEffect {
    BlackCatCunningThiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top nine cards of target opponent's library, exile two of them face down, then put the rest on the bottom of their library in a random order. You may play the exiled cards for as long as they remain exiled. Mana of any type can be spent to cast spells this way";
    }

    private BlackCatCunningThiefEffect(BlackCatCunningThiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlackCatCunningThiefEffect copy() {
        return new BlackCatCunningThiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || opponent == null || sourceObject == null) {
            return false;
        }
        CardsImpl topCards = new CardsImpl();
        topCards.addAllCards((Collection)opponent.getLibrary().getTopCards(game, 9));
        TargetCard target = new TargetCard(2, 2, Zone.LIBRARY, new FilterCard("card to exile"));
        controller.choose(this.outcome, (Cards)topCards, target, source, game);
        CardsImpl exiledCards = new CardsImpl(target.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).collect(Collectors.toList()));
        new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(false, CastManaAdjustment.AS_THOUGH_ANY_MANA_TYPE).setTargetPointer((TargetPointer)new FixedTargets((Cards)exiledCards, game)).apply(game, source);
        topCards.retainZone(Zone.LIBRARY, game);
        controller.putCardsOnBottomOfLibrary((Cards)topCards, game, source, false);
        return true;
    }
}

