/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.b.BladeOfSharedSoulsCopyEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BladeOfSharedSoulsEffect
extends OneShotEffect {
    BladeOfSharedSoulsEffect() {
        super(Outcome.Benefit);
        this.staticText = "for as long as {this} remains attached to it, you may have that creature become a copy of another target creature you control";
    }

    private BladeOfSharedSoulsEffect(BladeOfSharedSoulsEffect effect) {
        super((OneShotEffect)effect);
    }

    public BladeOfSharedSoulsEffect copy() {
        return new BladeOfSharedSoulsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent attachedPermanent = (Permanent)this.getValue("attachedPermanent");
        Permanent copyCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent equipment = source.getSourcePermanentIfItStillExists(game);
        if (attachedPermanent == null || copyCreature == null || equipment == null || !equipment.isAttachedTo(attachedPermanent.getId())) {
            return false;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.chooseUse(this.outcome, "Copy the creature?", source, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BladeOfSharedSoulsCopyEffect(copyCreature, attachedPermanent), source);
        return true;
    }
}

