/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class BlazingHopeTarget
extends TargetPermanent {
    public BlazingHopeTarget() {
        super((FilterPermanent)new FilterCreaturePermanent("creature with power greater than or equal to your life total"));
    }

    private BlazingHopeTarget(BlazingHopeTarget target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Permanent permanent = game.getPermanent(id);
        if (permanent != null) {
            if (!(this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source.getId()), playerId, source, game) && permanent.canBeTargetedBy(game.getObject(source), playerId, source, game))) {
                return false;
            }
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null && permanent.getPower().getValue() >= controller.getLife()) {
                return this.filter.match(permanent, playerId, source, game);
            }
        }
        return false;
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        int remainingTargets = this.minNumberOfTargets - this.targets.size();
        if (remainingTargets <= 0) {
            return true;
        }
        int count = 0;
        Player controller = game.getPlayer(sourceControllerId);
        MageObject targetSource = game.getObject(source);
        if (targetSource != null) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
                if (this.targets.containsKey(permanent.getId()) || !this.notTarget && !permanent.canBeTargetedBy(targetSource, sourceControllerId, source, game) || controller == null || permanent.getPower().getValue() < controller.getLife() || ++count < remainingTargets) continue;
                return true;
            }
        }
        return false;
    }

    public BlazingHopeTarget copy() {
        return new BlazingHopeTarget(this);
    }
}

