/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BlazingSunsteelEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class BlazingSunsteelTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    BlazingSunsteelTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BlazingSunsteelEffect(), false);
        this.addTarget((Target)new TargetAnyTarget());
    }

    private BlazingSunsteelTriggeredAbility(BlazingSunsteelTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BlazingSunsteelTriggeredAbility copy() {
        return new BlazingSunsteelTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent equipment = this.getSourcePermanentIfItStillExists(game);
        if (equipment == null || !event.getTargetId().equals(equipment.getAttachedTo())) {
            return false;
        }
        this.getEffects().setValue("equipped", (Object)equipment.getAttachedTo());
        this.getEffects().setValue("damage", (Object)event.getAmount());
        return true;
    }

    public String getRule() {
        return "Whenever equipped creature is dealt damage, it deals that much damage to any target.";
    }
}

