/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.DefenderAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;

public final class BlightPile
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("creatures with defender you control");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public BlightPile(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{B}");
        this.subtype.add((Object)SubType.PHYREXIAN);
        this.power = new MageInt(3);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)DefenderAbility.getInstance());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new LoseLifeOpponentsEffect(xValue).setText("each opponent loses X life, where X is the number of creatures with defender you control"), (Cost)new ManaCostsImpl("{2}{B}"));
        ability.addCost((Cost)new TapSourceCost());
        this.addAbility(ability.addHint(hint));
    }

    private BlightPile(BlightPile card) {
        super((CardImpl)card);
    }

    public BlightPile copy() {
        return new BlightPile(this);
    }

    static {
        filter.add((Predicate)new AbilityPredicate(DefenderAbility.class));
        xValue = new PermanentsOnBattlefieldCount(filter, null);
        hint = new ValueHint("Creatures with defender you control", xValue);
    }
}

