/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BlightbeetleEffect
extends ContinuousRuleModifyingEffectImpl {
    BlightbeetleEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Creatures your opponents control can't have +1/+1 counters put on them";
    }

    private BlightbeetleEffect(BlightbeetleEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public BlightbeetleEffect copy() {
        return new BlightbeetleEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getData().equals(CounterType.P1P1.getName())) {
            return false;
        }
        Permanent permanent = game.getPermanentEntering(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanent(event.getTargetId());
        }
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        return player != null && player.hasOpponent(source.getControllerId(), game);
    }
}

