/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BlightningEffect
extends OneShotEffect {
    BlightningEffect() {
        super(Outcome.Detriment);
        this.staticText = "That player or that planeswalker's controller discards two cards.";
    }

    private BlightningEffect(BlightningEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlightningEffect copy() {
        return new BlightningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        DiscardTargetEffect effect = new DiscardTargetEffect(2);
        effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
        return effect.apply(game, source);
    }
}

