/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BlimComedicGeniusEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent();

    BlimComedicGeniusEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player gains control of target permanent you control. Then each player loses life and discards cards equal to the number of permanents they control but don't own";
    }

    private BlimComedicGeniusEffect(BlimComedicGeniusEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlimComedicGeniusEffect copy() {
        return new BlimComedicGeniusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        game.addEffect(new GainControlTargetEffect(Duration.Custom, true, this.getTargetPointer().getFirst(game, source)).setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game)), source);
        game.processAction();
        HashMap<UUID, CardsImpl> cardsMap = new HashMap<UUID, CardsImpl>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            int count;
            player = game.getPlayer(playerId);
            if (player == null || (count = game.getBattlefield().count(filter, playerId, source, game)) < 1) continue;
            player.loseLife(count, game, source, true);
            TargetDiscard target = new TargetDiscard(count, StaticFilters.FILTER_CARD, playerId);
            player.choose(this.outcome, (Target)target, source, game);
            cardsMap.put(playerId, new CardsImpl((Collection)target.getTargets()));
        }
        for (Map.Entry entry : cardsMap.entrySet()) {
            player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            player.discard((Cards)entry.getValue(), false, source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getOwnerPredicate());
    }
}

