/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.InvestigateEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BlinkEffect
extends OneShotEffect {
    BlinkEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature. Its owner shuffles it into their library, then investigates";
    }

    private BlinkEffect(BlinkEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlinkEffect copy() {
        return new BlinkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getOwnerId());
        if (player == null) {
            return false;
        }
        player.shuffleCardsToLibrary((Card)permanent, game, source);
        InvestigateEffect.doInvestigate((UUID)player.getId(), (int)1, (Game)game, (Ability)source);
        return true;
    }
}

