/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class BlitzballWatcher
extends Watcher {
    private final Set<UUID> set = new HashSet<UUID>();

    BlitzballWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && ((DamagedPlayerEvent)event).isCombatDamage()) {
            if (Optional.ofNullable(event).map(GameEvent::getSourceId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(permanent -> permanent.isLegendary(game)).filter(permanent -> permanent.isCreature(game)).isPresent()) {
                this.set.addAll(game.getOpponents(event.getTargetId()));
            }
        }
    }

    public void reset() {
        super.reset();
        this.set.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((BlitzballWatcher)game.getState().getWatcher(BlitzballWatcher.class)).set.contains(source.getControllerId());
    }
}

