/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.PlayerLostLifeWatcher;

class BlitzwingCruelTormentorEffect
extends OneShotEffect {
    BlitzwingCruelTormentorEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent loses life equal to the life that player lost this turn. If no life is lost this way, convert {this}";
    }

    private BlitzwingCruelTormentorEffect(BlitzwingCruelTormentorEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlitzwingCruelTormentorEffect copy() {
        return new BlitzwingCruelTormentorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int lifeLost;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && (lifeLost = ((PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class)).getLifeLost(player.getId())) > 0 && player.loseLife(lifeLost, game, source, false) > 0) {
            return true;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        return permanent != null && permanent.transform(source, game);
    }
}

