/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class BloodForBonesEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card in your graveyard (to put onto the battlefield");
    private static final FilterCard filter2 = new FilterCreatureCard("creature card in your graveyard (to put into your hand");

    BloodForBonesEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return a creature card from your graveyard to the battlefield, then return another creature card from your graveyard to your hand.";
    }

    private BloodForBonesEffect(BloodForBonesEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodForBonesEffect copy() {
        return new BloodForBonesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().getCards(game).stream().noneMatch(card -> card.isCreature(game))) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(filter);
        if (player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) {
            player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        }
        if (player.getGraveyard().getCards(game).stream().noneMatch(card -> card.isCreature(game))) {
            return true;
        }
        target = new TargetCardInYourGraveyard(filter2);
        if (player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) {
            player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        }
        return true;
    }
}

