/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.mana.RedManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class BloodMoon
extends CardImpl {
    public BloodMoon(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{R}");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BloodMoonEffect()));
    }

    private BloodMoon(BloodMoon card) {
        super((CardImpl)card);
    }

    public BloodMoon copy() {
        return new BloodMoon(this);
    }

    static class BloodMoonEffect
    extends ContinuousEffectImpl {
        private static final FilterLandPermanent filter = new FilterLandPermanent();

        BloodMoonEffect() {
            super(Duration.WhileOnBattlefield, Outcome.Detriment);
            this.staticText = "Nonbasic lands are Mountains";
            this.dependencyTypes.add(DependencyType.BecomeMountain);
            this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
        }

        private BloodMoonEffect(BloodMoonEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public boolean apply(Game game, Ability source) {
            return false;
        }

        public BloodMoonEffect copy() {
            return new BloodMoonEffect(this);
        }

        public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
            for (Permanent land : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                switch (layer) {
                    case TypeChangingEffects_4: {
                        land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                        land.addSubType(game, new SubType[]{SubType.MOUNTAIN});
                        land.removeAllAbilities(source.getSourceId(), game);
                        land.addAbility((Ability)new RedManaAbility(), source.getSourceId(), game);
                    }
                }
            }
            return true;
        }

        public boolean hasLayer(Layer layer) {
            return layer == Layer.TypeChangingEffects_4;
        }

        static {
            filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
        }
    }
}

