/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.watchers.common.ManaPaidSourceWatcher;

class BloodOnTheSnowEffect
extends OneShotEffect {
    BloodOnTheSnowEffect() {
        super(Outcome.PutCardInPlay);
    }

    private BloodOnTheSnowEffect(BloodOnTheSnowEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodOnTheSnowEffect copy() {
        return new BloodOnTheSnowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int snow = ManaPaidSourceWatcher.getSnowPaid((UUID)source.getId(), (Game)game);
            FilterCard filter = new FilterCard("a creature or planeswalker card with mana value " + snow + " or less from your graveyard");
            filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, snow + 1));
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(1, 1, filter, true);
            controller.chooseTarget(this.outcome, (Target)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                return true;
            }
        }
        return false;
    }
}

