/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class BloodScrivenerReplacementEffect
extends ReplacementEffectImpl {
    BloodScrivenerReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would draw a card while you have no cards in hand, instead you draw two cards and you lose 1 life";
    }

    private BloodScrivenerReplacementEffect(BloodScrivenerReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BloodScrivenerReplacementEffect copy() {
        return new BloodScrivenerReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            player.drawCards(2, source, game, event);
            player.loseLife(1, game, source, false);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getPlayerId().equals(source.getControllerId())) {
            Player player = game.getPlayer(event.getPlayerId());
            return player != null && player.getHand().isEmpty();
        }
        return false;
    }
}

