/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BloodTributeLoseLifeEffect
extends OneShotEffect {
    BloodTributeLoseLifeEffect() {
        super(Outcome.Damage);
        this.staticText = "Target opponent loses half their life, rounded up";
    }

    private BloodTributeLoseLifeEffect(BloodTributeLoseLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodTributeLoseLifeEffect copy() {
        return new BloodTributeLoseLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Integer amount;
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null && (amount = Integer.valueOf((int)Math.ceil((float)player.getLife() / 2.0f))) > 0) {
            player.loseLife(amount.intValue(), game, source, false);
            game.getState().setValue(source.getSourceId().toString() + "_BloodTribute", (Object)amount);
            return true;
        }
        return false;
    }
}

