/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BloodTyrantEffect
extends OneShotEffect {
    BloodTyrantEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player loses 1 life. Put a +1/+1 counter on {this} for each 1 life lost this way";
    }

    private BloodTyrantEffect(BloodTyrantEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodTyrantEffect copy() {
        return new BloodTyrantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int counters = 0;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || player.loseLife(1, game, source, false) <= 0) continue;
                ++counters;
            }
            Permanent bloodTyrant = game.getPermanent(source.getSourceId());
            if (bloodTyrant != null && counters > 0) {
                bloodTyrant.addCounters(CounterType.P1P1.createInstance(counters), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

