/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.BloodthirstWatcher;

class BloodcrazedGoblinEffect
extends RestrictionEffect {
    BloodcrazedGoblinEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless an opponent has been dealt damage this turn";
    }

    private BloodcrazedGoblinEffect(BloodcrazedGoblinEffect effect) {
        super((RestrictionEffect)effect);
    }

    public BloodcrazedGoblinEffect copy() {
        return new BloodcrazedGoblinEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            BloodthirstWatcher watcher = (BloodthirstWatcher)game.getState().getWatcher(BloodthirstWatcher.class, source.getControllerId());
            return watcher != null && !watcher.conditionMet();
        }
        return false;
    }
}

