/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.choices.Choice;
import mage.choices.ChoiceCreatureType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BloodlineShamanEffect
extends OneShotEffect {
    BloodlineShamanEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a creature type. Reveal the top card of your library. If that card is a creature card of the chosen type, put it into your hand. Otherwise, put it into your graveyard";
    }

    private BloodlineShamanEffect(BloodlineShamanEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodlineShamanEffect copy() {
        return new BloodlineShamanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        MageObject sourceObject = game.getObject(source.getSourceId());
        if (sourceObject == null) {
            return false;
        }
        ChoiceCreatureType typeChoice = new ChoiceCreatureType(game, source);
        if (!controller.choose(this.outcome, (Choice)typeChoice, game)) {
            return false;
        }
        SubType subType = SubType.byDescription((String)typeChoice.getChoiceKey());
        game.informPlayers(sourceObject.getLogName() + " chosen type: " + typeChoice.getChoiceKey());
        if (controller.getLibrary().hasCards()) {
            Card card = controller.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            if (card != null) {
                if (card.isCreature(game) && subType != null && card.hasSubtype(subType, game)) {
                    controller.moveCards(card, Zone.HAND, source, game);
                } else {
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                }
            }
        }
        return true;
    }
}

