/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class BloodthirsterWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> attackMap = new HashMap<UUID, Set<UUID>>();

    BloodthirsterWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED || game.getPlayer(event.getTargetId()) == null) {
            return;
        }
        this.attackMap.computeIfAbsent(event.getSourceId(), x -> new HashSet()).add(event.getTargetId());
    }

    public void reset() {
        this.attackMap.clear();
        super.reset();
    }

    boolean checkAttacker(Permanent permanent, UUID defenderId) {
        return !this.attackMap.computeIfAbsent(permanent.getId(), x -> new HashSet()).contains(defenderId);
    }
}

