/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BloodthirstyAdversaryCopyEffect
extends OneShotEffect {
    BloodthirstyAdversaryCopyEffect() {
        super(Outcome.PlayForFree);
    }

    private BloodthirstyAdversaryCopyEffect(BloodthirstyAdversaryCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodthirstyAdversaryCopyEffect copy() {
        return new BloodthirstyAdversaryCopyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        LinkedHashSet<Card> cardsToExile = new LinkedHashSet<Card>();
        for (UUID cardId : this.getTargetPointer().getTargets(game, source)) {
            Card card = game.getCard(cardId);
            if (card == null) continue;
            cardsToExile.add(card);
        }
        if (cardsToExile.isEmpty()) {
            return false;
        }
        controller.moveCards(cardsToExile, Zone.EXILED, source, game);
        ApprovingObject approvingObject = new ApprovingObject(source, game);
        for (Card card : cardsToExile) {
            Card copiedCard = game.copyCard(card, source, controller.getId());
            if (copiedCard == null || !controller.chooseUse(this.outcome, "Cast " + copiedCard.getName() + " for free?", source, game)) continue;
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
            controller.cast(controller.chooseAbilityForCast(copiedCard, game, true), game, true, approvingObject);
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        }
        return true;
    }
}

