/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class BlossomingTortoiseCostReductionEffect
extends CostModificationEffectImpl {
    BlossomingTortoiseCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "activated abilities of lands you control cost {1} less to activate";
    }

    private BlossomingTortoiseCostReductionEffect(BlossomingTortoiseCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public BlossomingTortoiseCostReductionEffect copy() {
        return new BlossomingTortoiseCostReductionEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)1);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!abilityToModify.isActivatedAbility()) {
            return false;
        }
        Permanent permanent = abilityToModify.getSourcePermanentIfItStillExists(game);
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isLand(game);
    }
}

