/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

public final class BlossomingWreath
extends CardImpl {
    public BlossomingWreath(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{G}");
        this.getSpellAbility().addEffect((Effect)new BlossomingWreathEffect());
    }

    private BlossomingWreath(BlossomingWreath card) {
        super((CardImpl)card);
    }

    public BlossomingWreath copy() {
        return new BlossomingWreath(this);
    }

    static class BlossomingWreathEffect
    extends OneShotEffect {
        public BlossomingWreathEffect() {
            super(Outcome.GainLife);
            this.staticText = "You gain life equal to the number of creature cards in your graveyard";
        }

        private BlossomingWreathEffect(BlossomingWreathEffect effect) {
            super((OneShotEffect)effect);
        }

        public BlossomingWreathEffect copy() {
            return new BlossomingWreathEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Player controller = game.getPlayer(source.getControllerId());
            if (controller != null) {
                controller.gainLife(controller.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game), game, source);
                return true;
            }
            return false;
        }
    }
}

