/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.AddCardSubtypeAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.abilities.keyword.JobSelectAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.b.BlueMagesCaneEffect;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.card.DefendingPlayerOwnsCardPredicate;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

public final class BlueMagesCane
extends CardImpl {
    private static final FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("instant or sorcery card from defending player's graveyard");

    public BlueMagesCane(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{2}{U}");
        this.subtype.add((Object)SubType.EQUIPMENT);
        this.addAbility((Ability)new JobSelectAbility());
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostEquippedEffect(0, 2));
        ability.addEffect((Effect)new AddCardSubtypeAttachedEffect(SubType.WIZARD, AttachmentType.EQUIPMENT).setText(", is a Wizard in addition to its other types"));
        AttacksTriggeredAbility attackAbility = new AttacksTriggeredAbility((Effect)new BlueMagesCaneEffect());
        attackAbility.addTarget((Target)new TargetCardInGraveyard(0, 1, (FilterCard)filter));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)attackAbility, AttachmentType.EQUIPMENT).setText(", and has \"Whenever this creature attacks, exile up to one target instant or sorcery card from defending player's graveyard. If you do, copy it. You may cast the copy by paying {3} rather than paying its mana cost.\""));
        this.addAbility((Ability)ability);
        this.addAbility(new EquipAbility(2).withFlavorWord("Spirit of the Whalaqee"));
    }

    private BlueMagesCane(BlueMagesCane card) {
        super((CardImpl)card);
    }

    public BlueMagesCane copy() {
        return new BlueMagesCane(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)DefendingPlayerOwnsCardPredicate.instance);
    }
}

