/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BogardanPhoenixEffect
extends OneShotEffect {
    BogardanPhoenixEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it if it had a death counter on it. Otherwise, return it to the battlefield under your control and put a death counter on it.";
    }

    private BogardanPhoenixEffect(BogardanPhoenixEffect effect) {
        super((OneShotEffect)effect);
    }

    public BogardanPhoenixEffect copy() {
        return new BogardanPhoenixEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null || controller == null || permanent.getZoneChangeCounter(game) + 1 != source.getStackMomentSourceZCC()) {
            return false;
        }
        Card card = game.getCard(permanent.getId());
        if (card == null || card.getZoneChangeCounter(game) != source.getStackMomentSourceZCC()) {
            return false;
        }
        if (permanent.getCounters(game).containsKey(CounterType.DEATH)) {
            return controller.moveCards(card, Zone.EXILED, source, game);
        }
        Counters countersToAdd = new Counters(new Counter[0]);
        countersToAdd.addCounter(CounterType.DEATH.createInstance());
        game.setEnterWithCounters(source.getSourceId(), countersToAdd);
        return controller.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

