/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BombSquadBeginningEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with a fuse counter on it");

    public BombSquadBeginningEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a fuse counter on each creature with a fuse counter on it";
    }

    private BombSquadBeginningEffect(BombSquadBeginningEffect effect) {
        super((OneShotEffect)effect);
    }

    public BombSquadBeginningEffect copy() {
        return new BombSquadBeginningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            permanent.addCounters(CounterType.FUSE.createInstance(), source.getControllerId(), source, game);
            game.informPlayers(card.getName() + " puts a fuse counter on " + permanent.getName());
        }
        return true;
    }

    static {
        filter.add((Predicate)CounterType.FUSE.getPredicate());
    }
}

