/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BombSquadDamgeEffect
extends OneShotEffect {
    BombSquadDamgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove all fuse counters from it and destroy it. That creature deals 4 damage to its controller";
    }

    private BombSquadDamgeEffect(BombSquadDamgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public BombSquadDamgeEffect copy() {
        return new BombSquadDamgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (creature != null) {
            creature.removeAllCounters(CounterType.FUSE.getName(), source, game);
            creature.destroy(source, game, false);
        }
        if (creature == null) {
            creature = (Permanent)game.getLastKnownInformation(this.getTargetPointer().getFirst(game, source), Zone.BATTLEFIELD);
        }
        if (creature != null && (controller = game.getPlayer(creature.getControllerId())) != null) {
            controller.damage(4, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

