/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BonfireOfTheDamnedEffect
extends OneShotEffect {
    BonfireOfTheDamnedEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to target player or planeswalker and each creature that player or that planeswalker's controller controls";
    }

    private BonfireOfTheDamnedEffect(BonfireOfTheDamnedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int damage = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (damage < 1) {
            return false;
        }
        game.damagePlayerOrPermanent(source.getFirstTarget(), damage, source.getSourceId(), source, game, false, true);
        Player player = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (player == null) {
            return true;
        }
        for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game)) {
            perm.damage(damage, source.getSourceId(), source, game);
        }
        return true;
    }

    public BonfireOfTheDamnedEffect copy() {
        return new BonfireOfTheDamnedEffect(this);
    }
}

