/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.CreaturesDiedWatcher;

class BontuTheGlorifiedRestrictionEffect
extends RestrictionEffect {
    BontuTheGlorifiedRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack or block unless a creature died under your control this turn";
    }

    private BontuTheGlorifiedRestrictionEffect(BontuTheGlorifiedRestrictionEffect effect) {
        super((RestrictionEffect)effect);
    }

    public BontuTheGlorifiedRestrictionEffect copy() {
        return new BontuTheGlorifiedRestrictionEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            Player controller = game.getPlayer(source.getControllerId());
            CreaturesDiedWatcher watcher = (CreaturesDiedWatcher)game.getState().getWatcher(CreaturesDiedWatcher.class);
            if (controller != null && watcher != null) {
                return watcher.getAmountOfCreaturesDiedThisTurnByController(controller.getId()) == 0;
            }
            return true;
        }
        return false;
    }
}

