/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseExpansionSetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class BoosterTutorEffect
extends OneShotEffect {
    BoosterTutorEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Open a sealed Magic booster pack, reveal the cards, and put one of them into your hand";
    }

    private BoosterTutorEffect(BoosterTutorEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoosterTutorEffect copy() {
        return new BoosterTutorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ChooseExpansionSetEffect effect = new ChooseExpansionSetEffect(Outcome.UnboostCreature);
        effect.apply(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        String setChosen = null;
        if (effect.getValue("setchosen") != null) {
            setChosen = (String)effect.getValue("setchosen");
        } else if (game.getState().getValue(this.getId() + "_set") != null) {
            setChosen = (String)game.getState().getValue(this.getId() + "_set");
        }
        if (setChosen != null && controller != null) {
            List boosterPack;
            ExpansionSet expansionSet = Sets.findSet((String)setChosen);
            if (expansionSet != null && (boosterPack = expansionSet.create15CardBooster()) != null) {
                Card card;
                StringBuilder message = new StringBuilder(controller.getLogName()).append(" opened: ");
                for (Card card2 : boosterPack) {
                    message.append(card2.getName()).append(" ");
                }
                game.informPlayers(message.toString());
                TargetCard targetCard = new TargetCard(Zone.ALL, new FilterCard());
                HashSet cardsToLoad = new HashSet(boosterPack);
                game.loadCards(cardsToLoad, controller.getId());
                CardsImpl cards = new CardsImpl();
                cards.addAllCards((Collection)boosterPack);
                if (controller.choose(Outcome.PutCardInPlay, (Cards)cards, targetCard, source, game) && (card = game.getCard(targetCard.getFirstTarget())) != null) {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

