/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.b.BoreasChargerPredicate;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.filter.StaticFilters;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.TargetPlayer;
import mage.target.common.TargetCardInLibrary;

class BoreasChargerEffect
extends OneShotEffect {
    private static final FilterPlayer filter = new FilterPlayer("opponent who controls more lands than you");
    private static final FilterCard filter2 = new FilterCard("Plains cards");
    private static final FilterCard filter3 = new FilterCard("a card to put onto the battlefield tapped");

    public BoreasChargerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose an opponent who controls more lands than you. Search your library for a number of Plains cards equal to the difference, reveal those cards, put one of them onto the battlefield tapped and the rest into your hand, then shuffle";
    }

    private BoreasChargerEffect(BoreasChargerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoreasChargerEffect copy() {
        return new BoreasChargerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPlayer target = new TargetPlayer(1, 1, true, filter);
        controller.choose(this.outcome, (Target)target, source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        if (opponent == null) {
            controller.shuffleLibrary(source, game);
            return false;
        }
        int landDifference = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS, opponent.getId(), game).size();
        landDifference -= game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS, controller.getId(), game).size();
        landDifference = Math.abs(landDifference);
        TargetCardInLibrary target2 = new TargetCardInLibrary(0, landDifference, filter2);
        CardsImpl cardsToHand = new CardsImpl();
        if (controller.searchLibrary(target2, source, game)) {
            for (UUID cardId : target2.getTargets()) {
                Card card = game.getCard(cardId);
                if (card == null) continue;
                cardsToHand.add(card);
            }
        }
        if (cardsToHand.isEmpty()) {
            controller.shuffleLibrary(source, game);
            return true;
        }
        TargetCard target3 = new TargetCard(Zone.LIBRARY, filter3);
        Card cardToBattlefield = null;
        if (controller.choose(this.outcome, (Cards)cardsToHand, target3, source, game)) {
            cardToBattlefield = cardsToHand.get(target2.getFirstTarget(), game);
            cardsToHand.remove(cardToBattlefield);
        }
        if (cardToBattlefield != null) {
            controller.moveCards(cardToBattlefield, Zone.BATTLEFIELD, source, game, true, false, true, null);
        }
        controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)new BoreasChargerPredicate());
        filter2.add((Predicate)SubType.PLAINS.getPredicate());
    }
}

