/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class BorosStrikeCaptainWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> map = new HashMap<UUID, Set<MageObjectReference>>();

    BorosStrikeCaptainWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ATTACKER_DECLARED) {
            return;
        }
        Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> this.map.computeIfAbsent(permanent.getControllerId(), x -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game)));
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((BorosStrikeCaptainWatcher)game.getState().getWatcher(BorosStrikeCaptainWatcher.class)).map.getOrDefault(source.getControllerId(), Collections.emptySet()).size() >= 3;
    }
}

