/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BottledCloisterExileEffect
extends OneShotEffect {
    BottledCloisterExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile all cards from your hand face down";
    }

    private BottledCloisterExileEffect(BottledCloisterExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public BottledCloisterExileEffect copy() {
        return new BottledCloisterExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)controller.getHand());
        if (cards.isEmpty()) {
            return false;
        }
        controller.moveCardsToExile(cards.getCards(game), source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        cards.getCards(game).stream().filter(c -> game.getState().getZone(c.getId()) == Zone.EXILED).forEach(card -> card.setFaceDown(true, game));
        return true;
    }
}

