/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class BoundlessRealmsEffect
extends OneShotEffect {
    BoundlessRealmsEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to X basic land cards, where X is the number of lands you control, put them onto the battlefield tapped, then shuffle";
    }

    private BoundlessRealmsEffect(BoundlessRealmsEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoundlessRealmsEffect copy() {
        return new BoundlessRealmsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterLandPermanent filter = new FilterLandPermanent();
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        int amount = new PermanentsOnBattlefieldCount((FilterPermanent)filter).calculate(game, source, (Effect)this);
        TargetCardInLibrary target = new TargetCardInLibrary(0, amount, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        if (controller.searchLibrary(target, source, game)) {
            controller.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

