/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class BounteousKirinEffect
extends OneShotEffect {
    BounteousKirinEffect() {
        super(Outcome.GainLife);
        this.staticText = "you may gain life equal to that spell's mana value";
    }

    private BounteousKirinEffect(BounteousKirinEffect effect) {
        super((OneShotEffect)effect);
    }

    public BounteousKirinEffect copy() {
        return new BounteousKirinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell != null && (controller = game.getPlayer(source.getControllerId())) != null) {
            int life = spell.getManaValue();
            controller.gainLife(life, game, source);
            return true;
        }
        return false;
    }
}

