/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class BountyOfTheDeepEffect
extends OneShotEffect {
    BountyOfTheDeepEffect() {
        super(Outcome.Benefit);
        this.staticText = "if you have no land cards in your hand, seek a land card and a nonland card. Otherwise, seek two nonland cards";
    }

    private BountyOfTheDeepEffect(BountyOfTheDeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public BountyOfTheDeepEffect copy() {
        return new BountyOfTheDeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) < 1) {
            player.seekCard((FilterCard)StaticFilters.FILTER_CARD_LAND, source, game);
        } else {
            player.seekCard((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, source, game);
        }
        player.seekCard((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, source, game);
        return true;
    }
}

