/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BowerPassageEffect
extends RestrictionEffect {
    BowerPassageEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures with flying can't block creatures you control";
    }

    private BowerPassageEffect(BowerPassageEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return true;
    }

    public BowerPassageEffect copy() {
        return new BowerPassageEffect(this);
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return attacker == null || !attacker.isControlledBy(source.getControllerId()) || !blocker.getAbilities().contains((Ability)FlyingAbility.getInstance());
    }
}

