/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class BreachTheMultiverseEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("creature or planeswalker card");

    BreachTheMultiverseEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each player, choose a creature or planeswalker card in that player's graveyard. Put those cards onto the battlefield under your control";
    }

    private BreachTheMultiverseEffect(BreachTheMultiverseEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreachTheMultiverseEffect copy() {
        return new BreachTheMultiverseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
        target.withNotTarget(true);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getGraveyard().count(filter, game) < 1) continue;
            target.clearChosen();
            target.withChooseHint("from " + player.getName() + "'s graveyard");
            controller.choose(Outcome.PutCreatureInPlay, (Cards)player.getGraveyard(), (TargetCard)target, source, game);
            cards.add((Object)target.getFirstTarget());
        }
        return controller.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

