/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class BreachingLeviathanEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("nonblue creatures");

    public BreachingLeviathanEffect() {
        super(Outcome.Tap);
        this.staticText = "tap all nonblue creatures. Those creatures don't untap during their controllers' next untap steps";
    }

    private BreachingLeviathanEffect(BreachingLeviathanEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreachingLeviathanEffect copy() {
        return new BreachingLeviathanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> doNotUntapNextUntapStep = new ArrayList<Permanent>();
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
            creature.tap(source, game);
            doNotUntapNextUntapStep.add(creature);
        }
        if (!doNotUntapNextUntapStep.isEmpty()) {
            DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect("This creature");
            effect.setTargetPointer((TargetPointer)new FixedTargets(doNotUntapNextUntapStep, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)new ColorPredicate(ObjectColor.BLUE)));
    }
}

