/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BreakTheSpellEffect
extends OneShotEffect {
    BreakTheSpellEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target enchantment. If a permanent you controlled or a token was destroyed this way, draw a card.";
    }

    private BreakTheSpellEffect(BreakTheSpellEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreakTheSpellEffect copy() {
        return new BreakTheSpellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        boolean followupEffect = permanent.isControlledBy(source.getControllerId()) || StaticFilters.FILTER_PERMANENT_TOKEN.match((Object)permanent, game);
        boolean destroyed = permanent.destroy(source, game, false);
        game.processAction();
        if (followupEffect && destroyed) {
            new DrawCardSourceControllerEffect(1).apply(game, source);
        }
        return true;
    }
}

