/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class BreakingPointDestroyEffect
extends OneShotEffect {
    BreakingPointDestroyEffect() {
        super(Outcome.Benefit);
        this.staticText = "Any player may have {this} deal 6 damage to them. If no one does, destroy all creatures. Creatures destroyed this way can't be regenerated.";
    }

    private BreakingPointDestroyEffect(BreakingPointDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreakingPointDestroyEffect copy() {
        return new BreakingPointDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        StackObject spell = null;
        for (StackObject object : game.getStack()) {
            if (!(object instanceof Spell) || !object.getSourceId().equals(source.getSourceId())) continue;
            spell = object;
        }
        if (spell != null) {
            boolean destroyCreatures = true;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.chooseUse(Outcome.Detriment, "Have " + spell.getLogName() + " deal 6 damage to you?", source, game)) continue;
                destroyCreatures = false;
                player.damage(6, source.getSourceId(), source, game);
                game.informPlayers(player.getLogName() + " has " + spell.getName() + " deal 6 to them");
            }
            if (destroyCreatures) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game)) {
                    permanent.destroy(source, game, true);
                }
            }
            return destroyCreatures;
        }
        return false;
    }
}

