/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TurnPhase;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeEnchantedByPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class BreathOfFuryEffect
extends OneShotEffect {
    BreathOfFuryEffect() {
        super(Outcome.Benefit);
        this.staticText = "sacrifice it and attach {this} to a creature you control. If you do, untap all creatures you control and after this phase, there is an additional combat phase";
    }

    private BreathOfFuryEffect(BreathOfFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreathOfFuryEffect copy() {
        return new BreathOfFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null) {
            return false;
        }
        Permanent enchantedCreature = game.getPermanent((UUID)this.getValue("TriggeringCreatureId"));
        Player controller = game.getPlayer(source.getControllerId());
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature you control that could be enchanted by " + enchantment.getName());
        filter.add((Predicate)new CanBeEnchantedByPredicate((MageObject)enchantment));
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        if (enchantedCreature != null && controller != null && enchantedCreature.sacrifice(source, game) && target.canChoose(controller.getId(), source, game)) {
            controller.choose(this.outcome, (Target)target, source, game);
            Permanent newCreature = game.getPermanent(target.getFirstTarget());
            boolean success = false;
            if (newCreature != null) {
                Permanent oldCreature = game.getPermanent(enchantment.getAttachedTo());
                if (oldCreature != null) {
                    if (oldCreature.getId().equals(newCreature.getId())) {
                        success = true;
                    } else if (oldCreature.removeAttachment(enchantment.getId(), source, game) && newCreature.addAttachment(enchantment.getId(), source, game)) {
                        game.informPlayers(enchantment.getLogName() + " was unattached from " + oldCreature.getLogName() + " and attached to " + newCreature.getLogName());
                        success = true;
                    }
                } else if (newCreature.addAttachment(enchantment.getId(), source, game)) {
                    game.informPlayers(enchantment.getLogName() + " was attached to " + newCreature.getLogName());
                    success = true;
                }
            }
            if (success) {
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), controller.getId(), game)) {
                    permanent.untap(game);
                }
                game.getState().getTurnMods().add(new TurnMod(source.getControllerId()).withExtraPhase(TurnPhase.COMBAT));
            }
            return true;
        }
        return false;
    }
}

