/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.b.BreechesBrazenPlundererEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPlayersEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BreechesBrazenPlundererTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    BreechesBrazenPlundererTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private BreechesBrazenPlundererTriggeredAbility(BreechesBrazenPlundererTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PLAYERS;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(this.getControllerId()) && permanent.hasSubtype(SubType.PIRATE, game);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        HashSet<UUID> opponents = new HashSet<UUID>();
        this.getFilteredEvents((BatchEvent)((DamagedBatchForPlayersEvent)event), game).stream().map(GameEvent::getTargetId).forEach(opponents::add);
        if (opponents.isEmpty()) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new BreechesBrazenPlundererEffect(opponents));
        return true;
    }

    public BreechesBrazenPlundererTriggeredAbility copy() {
        return new BreechesBrazenPlundererTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more Pirates you control deal damage to your opponents, exile the top card of each of those opponents' libraries. You may play those cards this turn, and you may spend mana as though it were mana of any color to cast those spells.";
    }
}

