/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.cards.b.BreenaTheDemagogueEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BreenaTheDemagogueTriggeredAbility
extends TriggeredAbilityImpl {
    BreenaTheDemagogueTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardTargetEffect(1), false);
        this.addEffect((Effect)new BreenaTheDemagogueEffect());
    }

    private BreenaTheDemagogueTriggeredAbility(BreenaTheDemagogueTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BreenaTheDemagogueTriggeredAbility copy() {
        return new BreenaTheDemagogueTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DEFENDER_ATTACKED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        this.getEffects().setValue("attackedPlayer", (Object)event.getTargetId());
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkInterveningIfClause(Game game) {
        Player player = game.getPlayer((UUID)((Effect)this.getEffects().get(0)).getValue("attackedPlayer"));
        if (player == null) return false;
        if (player.getLife() <= game.getOpponents(this.getControllerId()).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(Player::getLife).min().orElse(0)) return false;
        return true;
    }

    public String getRule() {
        return "Whenever a player attacks one of your opponents, if that opponent has more life than another of your opponents, that attacking player draws a card and you put two +1/+1 counters on a creature you control.";
    }
}

