/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BribeTakerEffect
extends OneShotEffect {
    private static final String plusName = CounterType.P1P1.getName();

    BribeTakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each kind of counter on permanents you control, you may put your choice of a +1/+1 counter or a counter of that kind on {this}";
    }

    private BribeTakerEffect(BribeTakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BribeTakerEffect copy() {
        return new BribeTakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        Set counterTypes = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, source.getControllerId(), source, game).stream().map(p -> p.getCounters(game)).map(HashMap::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        if (counterTypes.contains(plusName)) {
            if (player.chooseUse(this.outcome, "Put a " + plusName + " counter on " + permanent.getName() + '?', source, game)) {
                permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
            }
            counterTypes.remove(plusName);
        }
        if (counterTypes.isEmpty()) {
            return true;
        }
        for (String cType : counterTypes) {
            if (!player.chooseUse(this.outcome, "Put a " + cType + " counter or " + plusName + " counter on " + permanent.getName() + '?', source, game)) continue;
            CounterType counterType = player.chooseUse(this.outcome, "Choose " + cType + " counter or " + plusName + " counter", null, cType, plusName, source, game) ? CounterType.findByName((String)cType) : CounterType.P1P1;
            permanent.addCounters(counterType.createInstance(), source, game);
        }
        return true;
    }
}

