/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BrightflameEffect
extends OneShotEffect {
    static final FilterPermanent filter = new FilterPermanent("creature");
    protected DynamicValue amount;

    BrightflameEffect(DynamicValue amount) {
        super(Outcome.Damage);
        this.amount = amount;
        this.staticText = "{this} deals X damage to target creature and each other creature that shares a color with it. You gain life equal to the damage dealt this way.";
    }

    private BrightflameEffect(BrightflameEffect effect) {
        super((OneShotEffect)effect);
        this.amount = effect.amount;
    }

    public boolean apply(Game game, Ability source) {
        int damageDealt = 0;
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target == null) {
            return false;
        }
        ObjectColor color = target.getColor(game);
        damageDealt += target.damage(this.amount.calculate(game, source, (Effect)this), source.getSourceId(), source, game);
        for (Permanent p : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), game)) {
            if (target.getId().equals(p.getId()) || !p.getColor(game).shares(color)) continue;
            damageDealt += p.damage(this.amount.calculate(game, source, (Effect)this), source.getSourceId(), source, game, false, true);
        }
        Player you = game.getPlayer(source.getControllerId());
        if (you != null && damageDealt > 0) {
            you.gainLife(damageDealt, game, source);
        }
        return true;
    }

    public BrightflameEffect copy() {
        return new BrightflameEffect(this);
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

