/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.CatSoldierCreatureToken;
import mage.players.Player;

class BrimazKingOfOreskosEffect
extends OneShotEffect {
    BrimazKingOfOreskosEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 white Cat Soldier creature token with vigilance that's blocking that creature";
    }

    private BrimazKingOfOreskosEffect(BrimazKingOfOreskosEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrimazKingOfOreskosEffect copy() {
        return new BrimazKingOfOreskosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CatSoldierCreatureToken token = new CatSoldierCreatureToken();
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        Permanent attackingCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (attackingCreature == null || game.getState().getCombat() == null) {
            return true;
        }
        CombatGroup combatGroup = game.getState().getCombat().findGroup(attackingCreature.getId());
        if (combatGroup == null) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent catToken = game.getPermanent(tokenId);
            if (catToken == null) continue;
            combatGroup.addBlocker(tokenId, source.getControllerId(), game);
            game.getCombat().addBlockingGroup(tokenId, attackingCreature.getId(), controller.getId(), game);
        }
        return true;
    }
}

