/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class BronzehideLionContinuousEffect
extends ContinuousEffectImpl {
    private final int zoneChangeCounter;
    private final Ability activatedAbility = new SimpleActivatedAbility((Effect)new GainAbilityAttachedEffect((Ability)IndestructibleAbility.getInstance(), AttachmentType.AURA, Duration.EndOfTurn), (Cost)new ManaCostsImpl("{G}{W}"));

    BronzehideLionContinuousEffect(int zoneChangeCounter) {
        super(Duration.Custom, Outcome.Neutral);
        this.zoneChangeCounter = zoneChangeCounter;
        this.dependencyTypes.add(DependencyType.AuraAddingRemoving);
    }

    private BronzehideLionContinuousEffect(BronzehideLionContinuousEffect ability) {
        super((ContinuousEffectImpl)ability);
        this.zoneChangeCounter = ability.zoneChangeCounter;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent sourceObject;
        if (game.getState().getZoneChangeCounter(source.getSourceId()) > this.zoneChangeCounter) {
            this.discard();
        }
        if ((sourceObject = game.getPermanent(source.getSourceId())) == null) {
            sourceObject = game.getPermanentEntering(source.getSourceId());
        }
        if (sourceObject == null) {
            return false;
        }
        Permanent lion = sourceObject;
        switch (layer) {
            case TypeChangingEffects_4: {
                lion.removeAllCardTypes(game);
                lion.addCardType(game, new CardType[]{CardType.ENCHANTMENT});
                lion.removeAllSubTypes(game);
                lion.addSubType(game, new SubType[]{SubType.AURA});
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                ArrayList<Ability> toRemove = new ArrayList<Ability>();
                for (Ability ability : lion.getAbilities(game)) {
                    if (lion.getSpellAbility().equals(ability)) continue;
                    toRemove.add(ability);
                }
                lion.removeAbilities(toRemove, source.getSourceId(), game);
                lion.getSpellAbility().getTargets().clear();
                lion.getSpellAbility().getEffects().clear();
                TargetControlledCreaturePermanent auraTarget = new TargetControlledCreaturePermanent();
                lion.getSpellAbility().addTarget((Target)auraTarget);
                lion.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
                lion.addAbility((Ability)new EnchantAbility((Target)auraTarget), source.getSourceId(), game);
                this.activatedAbility.setControllerId(source.getControllerId());
                lion.addAbility(this.activatedAbility, source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }

    public BronzehideLionContinuousEffect copy() {
        return new BronzehideLionContinuousEffect(this);
    }
}

