/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class BroodlordEffect
extends OneShotEffect {
    BroodlordEffect() {
        super(Outcome.Benefit);
        this.staticText = "distribute X +1/+1 counters among any number of other target creatures you control";
    }

    private BroodlordEffect(BroodlordEffect effect) {
        super((OneShotEffect)effect);
    }

    public BroodlordEffect copy() {
        return new BroodlordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Target target = (Target)source.getTargets().get(0);
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent;
            int counters = target.getTargetAmount(targetId);
            if (counters < 1 || (permanent = game.getPermanent(targetId)) == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(counters), source, game);
        }
        return true;
    }
}

